/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.impl.TestDAO;
import com.quantumdata.sct.dao.impl.TestResultsDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.ITestFilter;
import com.quantumdata.sct.engine.test.ModelTestFilter;
import com.quantumdata.sct.engine.test.StandardsTestFilter;
import com.quantumdata.sct.gui.common.SCTConstants;
import java.util.Collection;
import java.util.Vector;

public class TestCompiler {
    private static TestCompiler instance;
    private ITestFilter[] filters = new ITestFilter[]{new StandardsTestFilter(), new ModelTestFilter()};

    public static TestCompiler instance() {
        if (instance == null) {
            instance = new TestCompiler();
        }
        return instance;
    }

    public Collection getCompiledTests(String string) throws Exception {
        Vector<TestVO> vector = new Vector<TestVO>();
        TestResultsDAO testResultsDAO = (TestResultsDAO)XMLDAOFactory.getTestResultsDAO(SCTConstants.getUnitStorage(string));
        TestDAO testDAO = (TestDAO)XMLDAOFactory.getTestDAO();
        IPersistable[] iPersistableArray = testResultsDAO.readAll();
        for (int i = 0; i < iPersistableArray.length; ++i) {
            TestResultsVO testResultsVO = (TestResultsVO)iPersistableArray[i];
            for (TestResultVO testResultVO : testResultsVO.getStepresults()) {
                TestVO testVO = (TestVO)testDAO.read(testResultVO.getCapabilityId());
                vector.add(testVO);
            }
        }
        return vector;
    }

    public Collection compileTests(String string) {
        try {
            return this.getCompiledTests(string);
        }
        catch (DAOException dAOException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Object object2;
            Collection collection = this.getFilteredTests();
            long l = System.currentTimeMillis();
            TestResultsVO testResultsVO = new TestResultsVO();
            testResultsVO.setUnitId(string);
            testResultsVO.setLastUpdate(l);
            for (Object object2 : collection) {
                TestResultVO testResultVO = new TestResultVO();
                testResultVO.setCapabilityId(((TestVO)object2).getId().toString());
                testResultVO.setStatus("NOT TESTED");
                testResultVO.setLastUpdate(l);
                AbstractStepVO[] abstractStepVOArray = ((TestVO)object2).getStepsVO();
                for (int i = 0; i < abstractStepVOArray.length; ++i) {
                    if (abstractStepVOArray[i] instanceof CompositeStepVO) {
                        for (AbstractStepVO abstractStepVO : ((CompositeStepVO)abstractStepVOArray[i]).getChildStepsList()) {
                            TestStepResultVO testStepResultVO = new TestStepResultVO();
                            testStepResultVO.setStepId(abstractStepVO.getId().toString());
                            testStepResultVO.setStatus("NOT TESTED");
                            testResultVO.add(testStepResultVO);
                        }
                        continue;
                    }
                    TestStepResultVO testStepResultVO = new TestStepResultVO();
                    testStepResultVO.setStepId(abstractStepVOArray[i].getId().toString());
                    testStepResultVO.setStatus("NOT TESTED");
                    testResultVO.add(testStepResultVO);
                }
                testResultsVO.add(testResultVO);
            }
            object2 = "com.quantumdata.sct.dao.jaxb";
            TestResultsDAO.create(testResultsVO, SCTConstants.getUnitStorage(string), (String)object2);
            return collection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Vector(0);
        }
    }

    private Collection getFilteredTests() throws Exception {
        Object object;
        int n;
        Collection<TestVO> collection = new Vector<TestVO>();
        TestDAO testDAO = (TestDAO)XMLDAOFactory.getTestDAO();
        IPersistable[] iPersistableArray = testDAO.readAll();
        for (n = 0; n < iPersistableArray.length; ++n) {
            object = (TestVO)iPersistableArray[n];
            collection.add((TestVO)object);
        }
        for (n = 0; n < this.filters.length; ++n) {
            object = this.filters[n];
            collection = object.filter(collection);
        }
        return collection;
    }
}

